/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet;

import com.ibm.aui.swing.SrSwingRenderer;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRenderer;
import com.ibm.hwmca.fw.tasklet.impl.BusyCursorInterface;
import com.ibm.hwmca.fw.tasklet.impl.BusyTimer;
import com.ibm.hwmca.fw.tasklet.impl.XFrameUtils;
import com.ibm.hwmca.fw.util.HMCUserTaskManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.ui.framework.UserTaskManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.EventListener;
import java.util.Locale;
import java.util.Properties;

public class TaskletUserTaskManager
implements TaskletRenderer {
    private static final String TRACE_MASKT = "XTSKCUTT";
    private static final String TRACE_MASKF = "XTSKCUTF";
    private static final String TRACE_MASKD = "XTSKCUTD";
    private static final int TILL_BUSY_DELAY = 333;
    protected SrSwingRenderer swingRenderer = null;
    private String dataGroup;
    private BusyTimer busyTimer;
    private UserTaskManager utm;

    public TaskletUserTaskManager(String resourceName, String dataGroup, DataBean[] dataObjects, Locale locale, UserTaskManager utm) throws TaskManagerException {
        Trace.trace(TRACE_MASKF, "[TaskletUserTaskManager] <const>");
        try {
            this.utm = new HMCUserTaskManager(resourceName, dataGroup, (Object[])dataObjects, locale, utm);
        }
        catch (LinkageError e) {
            Trace.trace(TRACE_MASKF, "SPIKE, LinkageError, retrying to create the UTM");
            this.utm = new HMCUserTaskManager(resourceName, dataGroup, (Object[])dataObjects, locale, utm);
        }
        this.init(dataGroup);
    }

    public TaskletUserTaskManager(String resourceName, Properties properties, String dataGroup, DataBean[] dataObjects, Locale locale, UserTaskManager utm) throws TaskManagerException {
        Trace.trace(TRACE_MASKF, "[TaskletUserTaskManager] <const>");
        Trace.trace(TRACE_MASKF, "SPIKE: inbound:  " + resourceName + ", " + properties + ", " + dataGroup + ", " + dataObjects + ", " + locale + ", " + utm);
        Trace.trace(TRACE_MASKF, new Exception("Dummy exception for tracing"));
        try {
            this.utm = new HMCUserTaskManager(resourceName, properties, dataGroup, (Object[])dataObjects, locale, utm);
        }
        catch (LinkageError e) {
            Trace.trace(TRACE_MASKF, "SPIKE, LinkageError, retrying to create the UTM");
            this.utm = new HMCUserTaskManager(resourceName, properties, dataGroup, (Object[])dataObjects, locale, utm);
        }
        this.init(dataGroup);
    }

    public UserTaskManager getUserTaskManager() {
        return this.utm;
    }

    private void init(String dataGroup) {
        this.dataGroup = dataGroup;
        this.busyTimer = new BusyTimer(new BusyTarget());
    }

    public Component getComponent(String name) throws Exception {
        if (this.swingRenderer == null) {
            throw new Exception("The display is not Swing-enabled.");
        }
        Component comp = this.swingRenderer.getComponent(name);
        if (comp == null) {
            throw new Exception("Component not found for name: " + name);
        }
        return comp;
    }

    public Container getContainer() throws Exception {
        if (this.swingRenderer == null) {
            throw new Exception("This display is not Swing-enabled.");
        }
        Container c = this.swingRenderer.getContainer();
        if (c == null) {
            throw new Exception("SrSwingRenderer.getContainer() returned null");
        }
        return c;
    }

    public void setMouseCursorDefault() throws TaskletException {
        this.busyTimer.cancel();
    }

    public void setMouseCursorBusy() throws TaskletException {
        this.busyTimer.schedule(333L);
    }

    public Cursor getMouseCursor(String name) throws Exception {
        Cursor cursor = null;
        try {
            cursor = this.getComponent(name).getCursor();
        }
        catch (Exception e) {
            throw new Exception("Error getting cursor for component: " + name);
        }
        return cursor;
    }

    public void setMouseCursor(String name, Cursor cursor) throws Exception {
        try {
            this.getComponent(name).setCursor(cursor);
        }
        catch (Exception e) {
            throw new Exception("Error setting cursor for component: " + name);
        }
    }

    public synchronized void dispose() {
        Trace.trace(TRACE_MASKF, "[TaskletUserTaskManager] dispose(), forwarding to super.");
        if (this.utm != null) {
            this.utm.dispose();
        }
        this.utm = null;
    }

    public void addTaskActionListener(EventListener listener) {
        this.utm.addTaskActionListener((TaskActionListener)listener);
        this.utm.addCancelListener((TaskActionListener)listener);
        this.utm.addCommitListener((TaskActionListener)listener);
    }

    public void addElement(TaskletRenderer rti, String groupName, String newName, String parent, String insert) throws TaskletException {
        try {
            this.utm.addGroup(rti.getUserTaskManager(), groupName, newName, parent, insert);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[TaskletUserTaskManager] Exception during addGroup()\n" + XFrameUtils.getStackTrace(e));
            throw new TaskletException(e);
        }
    }

    public String[] getChildElementNames(String parent) {
        return this.utm.getChildElementNames(parent);
    }

    public void setElementText(String name, String text) throws TaskletException {
        try {
            this.utm.setCaptionText(name, text);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[TaskletUserTaskManager] Exception during setElementText()\n" + XFrameUtils.getStackTrace(e));
            throw new TaskletException(e);
        }
    }

    public String getElementText(String name) throws TaskletException {
        try {
            return this.utm.getCaptionText(name);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[TaskletUserTaskManager] Exception during getElementText()\n" + XFrameUtils.getStackTrace(e));
            throw new TaskletException(e);
        }
    }

    public int getElementStyle(String name) throws TaskletException {
        try {
            return this.utm.getStyle(name);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[TaskletUserTaskManager] Exception during getElementStyle()\n" + XFrameUtils.getStackTrace(e));
            throw new TaskletException(e);
        }
    }

    public void removeElement(String groupName) {
        this.utm.removeGroup(groupName);
    }

    public void show() throws TaskletException {
        try {
            this.utm.invoke();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[TaskletUserTaskManager] Exception during invoke()\n" + XFrameUtils.getStackTrace(e));
            throw new TaskletException(e);
        }
    }

    class BusyTarget
    implements BusyCursorInterface {
        BusyTarget() {
        }

        public void setMouseCursorDefault() {
            try {
                TaskletUserTaskManager.this.setMouseCursor(TaskletUserTaskManager.this.dataGroup, new Cursor(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setMouseCursorBusy() {
            try {
                TaskletUserTaskManager.this.setMouseCursor(TaskletUserTaskManager.this.dataGroup, new Cursor(3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

